//
//  SKPSMTPMessage.h
//
//  Created by Ian Baird on 10/28/08.
//
//  Copyright (c) 2008 Skorpiostech, Inc. All rights reserved.
//
//  Permission is hereby granted, free of charge, to any person
//  obtaining a copy of this software and associated documentation
//  files (the "Software"), to deal in the Software without
//  restriction, including without limitation the rights to use,
//  copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the
//  Software is furnished to do so, subject to the following
//  conditions:
//
//  The above copyright notice and this permission notice shall be
//  included in all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
//  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
//  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
//  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
//  OTHER DEALINGS IN THE SOFTWARE.
//

#import <Foundation/Foundation.h>
#import <CoreServices/CoreServices.h>

enum 
{
    kSKPSMTPIdle = 0,
    kSKPSMTPConnecting,
    kSKPSMTPWaitingEHLOReply,
    kSKPSMTPWaitingTLSReply,
    kSKPSMTPWaitingLOGINUsernameReply,
    kSKPSMTPWaitingLOGINPasswordReply,
	kSKPSMTPWaitingCRAMMD5Reply,
    kSKPSMTPWaitingAuthSuccess,
    kSKPSMTPWaitingFromReply,
    kSKPSMTPWaitingToReply,
    kSKPSMTPWaitingForEnterMail,
    kSKPSMTPWaitingSendSuccess,
    kSKPSMTPWaitingQuitReply,
    kSKPSMTPMessageSent
};
typedef unsigned SKPSMTPState;
    
// Message part keys
#define kSKPSMTPPartContentDispositionKey		@"kSKPSMTPPartContentDispositionKey"
#define kSKPSMTPPartContentTypeKey				@"kSKPSMTPPartContentTypeKey"
#define kSKPSMTPPartMessageKey					@"kSKPSMTPPartMessageKey"
#define kSKPSMTPPartContentTransferEncodingKey	@"kSKPSMTPPartContentTransferEncodingKey"

// Error message codes
#define kSKPSMPTErrorConnectionTimeout -5
#define kSKPSMTPErrorConnectionFailed -3
#define kSKPSMTPErrorConnectionInterrupted -4
#define kSKPSMTPErrorUnsupportedLogin -2
#define kSKPSMTPErrorTLSFail -1
#define kSKPSMTPErrorInvalidUserPass 535
#define kSKPSMTPErrorInvalidMessage 550
#define kSKPSMTPErrorInvalidMessage554 554
#define kSKPSMTPErrorNoRelay 530

#define BOUNDARY_STRING @"SimpleSMTP--05-13-2009"

enum DelegateVerbosityLevels {
	kSKPSMTPMessageVerbosityNormal = 0,
	kSKPSMTPMessageVerbosityError,
	kSKPSMTPMessageVerbosityDebug
};

@class SKPSMTPMessage;

@protocol SKPSMTPMessageDelegate
@required

- (void)messageSent:(SKPSMTPMessage *)message;
- (void)messageFailed:(SKPSMTPMessage *)message error:(NSError *)error;
- (void)verboseMessage:(NSString *)msg level:(int)verbosityLevel;

@end

@interface SKPSMTPMessage : NSObject <NSCopying, NSStreamDelegate>
{
    NSString *login;
    NSString *pass;
    NSString *relayHost;
    NSArray *relayPorts;
    
    NSString *subject;
    NSString *fromEmail;
	NSString *fullName;
    NSString *toEmail;
	NSString *ccEmail;
	NSString *bccEmail;
    NSArray *parts;
	NSString *aux;
    
    int requiresAuth;
    BOOL wantsSecure;
    BOOL validateSSLChain;
    
    id <SKPSMTPMessageDelegate> delegate;
    NSTimeInterval connectTimeout;
	
	// Private ivars
	NSOutputStream *outputStream;
    NSInputStream *inputStream;
    
    SKPSMTPState sendState;
    BOOL isSecure;
	BOOL haveSupportedAuthMethods;
	BOOL serverSupportsSTARTTLS;
    
    // Auth support flags
    BOOL serverAuthCRAMMD5;
    BOOL serverAuthPLAIN;
    BOOL serverAuthLOGIN;
    BOOL serverAuthDIGESTMD5;
    
    // Content support flags
    BOOL server8bitMessages;
	int textEncoding;
    
    NSMutableString *inputString;
    NSTimer *watchdogTimer;
	CFRunLoopRef backgroundRunloop;
	NSMutableArray *allRecipients;
}

@property (copy) NSString *login;
@property (copy) NSString *pass;
@property (copy) NSString *relayHost;
@property (copy) NSArray *relayPorts;
@property (copy) NSString *subject;
@property (copy) NSString *fromEmail;
@property (copy) NSString *fullName;
@property (copy) NSString *toEmail;
@property (copy) NSString *ccEmail;
@property (copy) NSString *bccEmail;
@property (copy) NSArray *parts;
@property (copy) NSString *aux;
@property int requiresAuth;
@property BOOL validateSSLChain;
@property BOOL wantsSecure;
@property (assign) id <SKPSMTPMessageDelegate> delegate;
@property NSTimeInterval connectTimeout;

- (BOOL)send;

@end
